<?php
require 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST["username"]);
    $password = $_POST["password"];
    $confirm  = $_POST["confirm_password"];

    if ($password !== $confirm) {
        die("Password tidak cocok.");
    }

    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
    $stmt->execute([$username]);
    if ($stmt->fetch()) {
        die("Username sudah digunakan.");
    }

    $hash = password_hash($password, PASSWORD_BCRYPT);
    $stmt = $pdo->prepare("INSERT INTO users (username, password_hash) VALUES (?, ?)");
    $stmt->execute([$username, $hash]);

    echo "Registrasi berhasil. <a href='login.php'>Login di sini</a>.";
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Register - EduPlay Point</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="container mt-5">
    <h2>Registrasi</h2>
    <form method="POST">
        <div class="mb-3">
            <label>Username:</label>
            <input type="text" name="username" required class="form-control">
        </div>
        <div class="mb-3">
            <label>Password:</label>
            <input type="password" name="password" required class="form-control">
        </div>
        <div class="mb-3">
            <label>Konfirmasi Password:</label>
            <input type="password" name="confirm_password" required class="form-control">
        </div>
        <button class="btn btn-primary">Daftar</button>
        <a href="login.php" class="btn btn-link">Sudah punya akun?</a>
    </form>
</body>
</html>
