<?php
require 'db.php';

if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION["user_id"];

// Ambil data user
$stmt = $pdo->prepare("SELECT coins FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Ambil reward
$rewards = $pdo->query("SELECT * FROM rewards WHERE stock > 0")->fetchAll();

// Ambil status redeem
$requests = $pdo->prepare("
    SELECT r.name, rr.coin_cost, rr.status
    FROM reward_requests rr
    JOIN rewards r ON rr.reward_id = r.id
    WHERE rr.user_id = ?
");
$requests->execute([$user_id]);
$my_requests = $requests->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Dashboard - EduPlay Point</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="container mt-5">
    <h2>Selamat datang, <?= htmlspecialchars($_SESSION["username"]) ?>!</h2>
    <p><strong>Saldo Coin:</strong> <?= $user['coins'] ?></p>
    <a href="logout.php" class="btn btn-danger mb-4">Logout</a>

    <h4>Main Game:</h4>
    <div class="mb-4">
        <a href="game/Carambol/index.html" class="btn btn-primary">Carambol</a>
        <a href="game/Matematika/index.html" class="btn btn-primary">Matematika</a>
        <a href="game/Fisika/index.html" class="btn btn-primary">Fisika</a>
        <a href="game/Roulette/index.html" class="btn btn-primary">Roulette</a>
        <a href="game/Biologi/index.html" class="btn btn-primary">Biologi</a>
    </div>

    <h4>Reward Digital:</h4>
    <form method="POST" action="api/redeem_reward.php">
        <table class="table">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Cost</th>
                    <th>Stock</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($rewards as $reward): ?>
                <tr>
                    <td><?= htmlspecialchars($reward['name']) ?></td>
                    <td><?= $reward['cost_coin'] ?></td>
                    <td><?= $reward['stock'] ?></td>
                    <td>
                        <button name="reward_id" value="<?= $reward['id'] ?>" class="btn btn-sm btn-success"
                        onclick="return confirm('Tukar dengan <?= $reward['cost_coin'] ?> coin?')">
                            Tukar
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </form>

    <h4>Status Permintaan Reward:</h4>
    <table class="table">
        <thead>
            <tr>
                <th>Reward</th>
                <th>Coin</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($my_requests as $req): ?>
            <tr>
                <td><?= htmlspecialchars($req['name']) ?></td>
                <td><?= $req['coin_cost'] ?></td>
                <td><?= ucfirst($req['status']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
