<?php
require '../db.php';

if (!isset($_SESSION["user_id"])) {
    header("Location: ../login.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["reward_id"])) {
    $user_id = $_SESSION["user_id"];
    $reward_id = (int)$_POST["reward_id"];

    // Ambil data reward
    $stmt = $pdo->prepare("SELECT * FROM rewards WHERE id = ?");
    $stmt->execute([$reward_id]);
    $reward = $stmt->fetch();

    if (!$reward || $reward['stock'] <= 0) {
        die("Reward tidak tersedia.");
    }

    // Ambil coin user
    $stmt = $pdo->prepare("SELECT coins FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();

    if ($user['coins'] < $reward['cost_coin']) {
        die("Coin tidak cukup.");
    }

    // Kurangi coin & insert request
    $pdo->beginTransaction();

    try {
        $stmt = $pdo->prepare("UPDATE users SET coins = coins - ? WHERE id = ?");
        $stmt->execute([$reward['cost_coin'], $user_id]);

        $stmt = $pdo->prepare("INSERT INTO reward_requests (user_id, reward_id, coin_cost) VALUES (?, ?, ?)");
        $stmt->execute([$user_id, $reward_id, $reward['cost_coin']]);

        $pdo->commit();
        header("Location: ../dashboard.php");
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "Terjadi kesalahan: " . $e->getMessage();
    }
}
?>
