<?php
require '../db.php';

if (!isset($_SESSION["user_id"])) {
    http_response_code(401);
    echo "Unauthorized";
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);
$score = (int)$data["points"];
$game = trim($data["game"]);

if ($score <= 0 || empty($game)) {
    http_response_code(400);
    echo "Invalid input";
    exit;
}

$user_id = $_SESSION["user_id"];

// Tambah coin
$stmt = $pdo->prepare("UPDATE users SET coins = coins + ? WHERE id = ?");
$stmt->execute([$score, $user_id]);

// Log game
$stmt = $pdo->prepare("INSERT INTO game_logs (user_id, game_name, score, coins_added) VALUES (?, ?, ?, ?)");
$stmt->execute([$user_id, $game, $score, $score]);

echo "Score berhasil ditambahkan.";
?>
