<?php
require '../db.php';

if (!isset($_SESSION["admin_id"])) {
    header("Location: index.php");
    exit;
}

// Ambil semua user
$users = $pdo->query("SELECT id, username, coins FROM users")->fetchAll();

// Ambil semua reward
$rewards = $pdo->query("SELECT * FROM rewards")->fetchAll();

// Ambil semua request
$requests = $pdo->query("
    SELECT rr.id, u.username, r.name AS reward_name, rr.coin_cost, rr.status
    FROM reward_requests rr
    JOIN users u ON rr.user_id = u.id
    JOIN rewards r ON rr.reward_id = r.id
")->fetchAll();

// Proses form tambah coin
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["add_coin_user"])) {
    $uid = (int)$_POST["user_id"];
    $coins = (int)$_POST["coins"];
    $stmt = $pdo->prepare("UPDATE users SET coins = coins + ? WHERE id = ?");
    $stmt->execute([$coins, $uid]);
    header("Location: dashboard.php");
    exit;
}

// Proses tambah reward
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["add_reward"])) {
    $name = $_POST["name"];
    $cost = (int)$_POST["cost_coin"];
    $stock = (int)$_POST["stock"];
    $code = $_POST["item_code"];
    $stmt = $pdo->prepare("INSERT INTO rewards (name, cost_coin, stock, item_code) VALUES (?, ?, ?, ?)");
    $stmt->execute([$name, $cost, $stock, $code]);
    header("Location: dashboard.php");
    exit;
}

// Approve / reject
if (isset($_GET["action"]) && isset($_GET["id"])) {
    $id = (int)$_GET["id"];
    $stmt = $pdo->prepare("SELECT * FROM reward_requests WHERE id = ?");
    $stmt->execute([$id]);
    $req = $stmt->fetch();

    if ($req && $req['status'] === 'pending') {
        if ($_GET["action"] == "approve") {
            $stmt = $pdo->prepare("UPDATE reward_requests SET status = 'approved' WHERE id = ?");
            $stmt->execute([$id]);
        } elseif ($_GET["action"] == "reject") {
            // Kembalikan coin ke user
            $stmt = $pdo->prepare("UPDATE users SET coins = coins + ? WHERE id = ?");
            $stmt->execute([$req['coin_cost'], $req['user_id']]);
            $stmt = $pdo->prepare("UPDATE reward_requests SET status = 'rejected' WHERE id = ?");
            $stmt->execute([$id]);
        }
        header("Location: dashboard.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard - EduPlay</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="container mt-4">
    <h2>Admin Panel</h2>
    <a href="logout.php" class="btn btn-danger mb-3">Logout</a>

    <h4>Inject Coin ke User</h4>
    <form method="POST" class="row g-2 mb-4">
        <input type="hidden" name="add_coin_user" value="1">
        <div class="col-md-4">
            <select name="user_id" class="form-select" required>
                <option value="">Pilih User</option>
                <?php foreach ($users as $u): ?>
                    <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['username']) ?> (<?= $u['coins'] ?> coin)</option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <input type="number" name="coins" placeholder="Jumlah Coin" class="form-control" required>
        </div>
        <div class="col-md-2">
            <button class="btn btn-primary">Tambah Coin</button>
        </div>
    </form>

    <h4>Buat Reward Digital</h4>
    <form method="POST" class="row g-2 mb-4">
        <input type="hidden" name="add_reward" value="1">
        <div class="col-md-3">
            <input type="text" name="name" placeholder="Nama Reward" class="form-control" required>
        </div>
        <div class="col-md-2">
            <input type="number" name="cost_coin" placeholder="Cost Coin" class="form-control" required>
        </div>
        <div class="col-md-2">
            <input type="number" name="stock" placeholder="Stock" class="form-control" required>
        </div>
        <div class="col-md-3">
            <input type="text" name="item_code" placeholder="Kode Item" class="form-control" required>
        </div>
        <div class="col-md-2">
            <button class="btn btn-success">Tambah Reward</button>
        </div>
    </form>

    <h4>Permintaan Reward</h4>
    <table class="table">
        <thead>
            <tr>
                <th>User</th>
                <th>Reward</th>
                <th>Coin</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($requests as $req): ?>
            <tr>
                <td><?= htmlspecialchars($req['username']) ?></td>
                <td><?= htmlspecialchars($req['reward_name']) ?></td>
                <td><?= $req['coin_cost'] ?></td>
                <td><?= ucfirst($req['status']) ?></td>
                <td>
                    <?php if ($req['status'] == 'pending'): ?>
                        <a href="?action=approve&id=<?= $req['id'] ?>" class="btn btn-sm btn-success">Approve</a>
                        <a href="?action=reject&id=<?= $req['id'] ?>" class="btn btn-sm btn-danger">Reject</a>
                    <?php else: ?>
                        <em>-</em>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
